"""
اختبار Google Maps API
"""

import googlemaps
from dotenv import load_dotenv
import os

# تحميل المفاتيح
load_dotenv()

print("=" * 60)
print("🧪 اختبار Google Maps API")
print("=" * 60)

# الحصول على المفتاح
api_key = os.getenv('GOOGLE_MAPS_API_KEY')

if not api_key:
    print("❌ لم يتم العثور على GOOGLE_MAPS_API_KEY في ملف .env")
    exit(1)

print(f"✅ تم العثور على API Key: {api_key[:20]}...")

# إنشاء عميل Google Maps
try:
    gmaps = googlemaps.Client(key=api_key)
    print("✅ تم إنشاء عميل Google Maps بنجاح")
except Exception as e:
    print(f"❌ خطأ في إنشاء العميل: {str(e)}")
    exit(1)

# اختبار بحث بسيط
print("\n" + "=" * 60)
print("🔍 اختبار البحث: مطاعم في الرياض")
print("=" * 60)

try:
    # بحث بسيط
    places_result = gmaps.places(
        query="مطاعم في الرياض",
        language='ar'
    )
    
    if places_result.get('status') == 'OK':
        results = places_result.get('results', [])
        print(f"✅ البحث نجح! تم العثور على {len(results)} نتيجة")
        
        # عرض أول 3 نتائج
        print("\n📋 أول 3 نتائج:")
        for i, place in enumerate(results[:3], 1):
            print(f"\n{i}. {place.get('name', 'بدون اسم')}")
            print(f"   📍 {place.get('formatted_address', 'N/A')}")
            print(f"   ⭐ {place.get('rating', 'N/A')}")
        
        print("\n" + "=" * 60)
        print("✅ Google Maps API يعمل بشكل ممتاز!")
        print("=" * 60)
        
    elif places_result.get('status') == 'REQUEST_DENIED':
        print("❌ الطلب مرفوض!")
        print(f"السبب: {places_result.get('error_message', 'غير معروف')}")
        print("\n💡 الحلول المحتملة:")
        print("1. تأكد من تفعيل Places API في Google Cloud Console")
        print("2. تحقق من صحة API Key")
        print("3. تأكد من ربط بطاقة ائتمان (مطلوب حتى للخطة المجانية)")
        
    elif places_result.get('status') == 'OVER_QUERY_LIMIT':
        print("❌ تجاوزت حد الاستخدام!")
        print("💡 راجع حدود استخدام API في Google Cloud Console")
        
    else:
        print(f"⚠️ حالة غير متوقعة: {places_result.get('status')}")
        print(f"التفاصيل: {places_result}")
        
except Exception as e:
    print(f"❌ خطأ في الاختبار: {str(e)}")
    import traceback
    print("\nتفاصيل الخطأ:")
    traceback.print_exc()



