# PowerShell script لتشغيل النظام
Write-Host "╔═══════════════════════════════════════════════════════════╗" -ForegroundColor Cyan
Write-Host "║                                                           ║" -ForegroundColor Cyan
Write-Host "║        🚀 نظام التسويق الاحترافي المتقدم 🚀              ║" -ForegroundColor Cyan
Write-Host "║                                                           ║" -ForegroundColor Cyan
Write-Host "╚═══════════════════════════════════════════════════════════╝" -ForegroundColor Cyan
Write-Host ""

# التحقق من وجود Python
try {
    $pythonVersion = python --version 2>&1
    Write-Host "✅ Python مثبت: $pythonVersion" -ForegroundColor Green
} catch {
    Write-Host "❌ Python غير مثبت! يرجى تثبيت Python 3.8 أو أحدث" -ForegroundColor Red
    Write-Host ""
    Write-Host "يمكنك تحميله من: https://www.python.org/downloads/" -ForegroundColor Yellow
    Read-Host "اضغط Enter للخروج"
    exit 1
}

Write-Host ""

# إنشاء ملف .env إذا لم يكن موجوداً
if (-not (Test-Path ".env")) {
    Write-Host "⚠️  ملف .env غير موجود!" -ForegroundColor Yellow
    Write-Host ""
    Write-Host "جارٍ إنشاء ملف .env..." -ForegroundColor Cyan
    
    python setup_env.py
    
    if ($LASTEXITCODE -eq 0) {
        Write-Host "✅ تم إنشاء ملف .env بنجاح" -ForegroundColor Green
    } else {
        Write-Host "❌ فشل إنشاء ملف .env" -ForegroundColor Red
        Read-Host "اضغط Enter للخروج"
        exit 1
    }
} else {
    Write-Host "✅ ملف .env موجود" -ForegroundColor Green
}

Write-Host ""
Write-Host "📦 تثبيت المكتبات المطلوبة..." -ForegroundColor Cyan
Write-Host ""

# تثبيت المكتبات
pip install -q -r requirements.txt

if ($LASTEXITCODE -eq 0) {
    Write-Host "✅ تم تثبيت جميع المكتبات" -ForegroundColor Green
} else {
    Write-Host "❌ فشل تثبيت المكتبات" -ForegroundColor Red
    Read-Host "اضغط Enter للخروج"
    exit 1
}

Write-Host ""
Write-Host "🗄️  تهيئة قاعدة البيانات..." -ForegroundColor Cyan
Write-Host ""

# تهيئة قاعدة البيانات
python database.py

if ($LASTEXITCODE -eq 0) {
    Write-Host "✅ تم تهيئة قاعدة البيانات" -ForegroundColor Green
} else {
    Write-Host "❌ فشل تهيئة قاعدة البيانات" -ForegroundColor Red
    Read-Host "اضغط Enter للخروج"
    exit 1
}

Write-Host ""
Write-Host "╔═══════════════════════════════════════════════════════════╗" -ForegroundColor Green
Write-Host "║                    🎉 جاهز للعمل! 🎉                     ║" -ForegroundColor Green
Write-Host "╚═══════════════════════════════════════════════════════════╝" -ForegroundColor Green
Write-Host ""
Write-Host "🌐 سيتم فتح المتصفح على: http://localhost:5000" -ForegroundColor Cyan
Write-Host ""
Write-Host "للإيقاف: اضغط Ctrl+C" -ForegroundColor Yellow
Write-Host ""

# فتح المتصفح بعد 3 ثواني
Start-Sleep -Seconds 3
Start-Process "http://localhost:5000"

# تشغيل التطبيق
python app.py



