@echo off
chcp 65001 >nul
echo ╔═══════════════════════════════════════════════════════════╗
echo ║                                                           ║
echo ║        🚀 نظام التسويق الاحترافي المتقدم 🚀              ║
echo ║                                                           ║
echo ╚═══════════════════════════════════════════════════════════╝
echo.

REM التحقق من وجود Python
python --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ Python غير مثبت! يرجى تثبيت Python 3.8 أو أحدث
    echo.
    echo يمكنك تحميله من: https://www.python.org/downloads/
    pause
    exit /b 1
)

echo ✅ Python مثبت

REM التحقق من وجود ملف .env
if not exist .env (
    echo.
    echo ⚠️  ملف .env غير موجود!
    echo.
    echo هل تريد إنشاءه الآن؟ (y/n)
    set /p create_env=
    
    if /i "%create_env%"=="y" (
        echo.
        echo إنشاء ملف .env...
        copy .env.example .env >nul
        echo ✅ تم إنشاء ملف .env
        echo.
        echo ⚠️  يرجى فتح ملف .env وإضافة مفاتيح API الخاصة بك
        echo.
        notepad .env
        echo.
        echo اضغط Enter بعد إضافة المفاتيح للمتابعة...
        pause >nul
    ) else (
        echo.
        echo ❌ لا يمكن تشغيل النظام بدون ملف .env
        pause
        exit /b 1
    )
)

echo.
echo 📦 التحقق من المكتبات المطلوبة...
echo.

REM تثبيت المكتبات
pip install -q -r requirements.txt
if %errorlevel% neq 0 (
    echo ❌ فشل تثبيت المكتبات
    pause
    exit /b 1
)

echo ✅ تم تثبيت جميع المكتبات

echo.
echo 🗄️  تهيئة قاعدة البيانات...
echo.

REM تهيئة قاعدة البيانات
python database.py
if %errorlevel% neq 0 (
    echo ❌ فشل تهيئة قاعدة البيانات
    pause
    exit /b 1
)

echo.
echo ╔═══════════════════════════════════════════════════════════╗
echo ║                    🎉 جاهز للعمل! 🎉                     ║
echo ╚═══════════════════════════════════════════════════════════╝
echo.
echo 🌐 سيتم فتح المتصفح تلقائياً على: http://localhost:5000
echo.
echo للإيقاف: اضغط Ctrl+C
echo.

REM الانتظار قليلاً ثم فتح المتصفح
timeout /t 3 /nobreak >nul
start http://localhost:5000

REM تشغيل التطبيق
python app.py

pause



