import os
from dotenv import load_dotenv

load_dotenv()

class Config:
    """إعدادات التطبيق"""
    
    # API Keys
    DEEPSEEK_API_KEY = os.getenv('DEEPSEEK_API_KEY')
    OPENAI_API_KEY = os.getenv('OPENAI_API_KEY')
    GOOGLE_MAPS_API_KEY = os.getenv('GOOGLE_MAPS_API_KEY')
    
    # Database
    DATABASE_URL = os.getenv('DATABASE_URL', 'sqlite:///marketing_system.db')
    
    # Flask
    SECRET_KEY = os.getenv('SECRET_KEY', 'dev-secret-key')
    FLASK_ENV = os.getenv('FLASK_ENV', 'development')
    
    # AI Settings
    DEFAULT_AI_MODEL = 'gpt-4'  # يمكن تغييره إلى deepseek
    AI_TEMPERATURE = 0.7
    AI_MAX_TOKENS = 500
    
    # Scraping Settings
    MAX_RESULTS_PER_SEARCH = 60
    REQUEST_TIMEOUT = 30
    
    @staticmethod
    def validate():
        """التحقق من وجود جميع المفاتيح المطلوبة"""
        required_keys = [
            'GOOGLE_MAPS_API_KEY',
        ]
        missing_keys = [key for key in required_keys if not getattr(Config, key)]
        if missing_keys:
            raise ValueError(f"Missing required configuration: {', '.join(missing_keys)}")
        return True



