# 🚀 نظام التسويق الاحترافي المتقدم

نظام متكامل لاستخراج بيانات الأعمال التجارية من Google Maps ومراسلتهم عبر WhatsApp مع دعم الذكاء الاصطناعي

## ✨ المميزات

- 🗺️ **استخراج بيانات احترافي**: جلب معلومات الأعمال من Google Maps (الاسم، الهاتف، العنوان، التقييم، الموقع)
- 🤖 **ذكاء اصطناعي متقدم**: توليد رسائل تسويقية مخصصة باستخدام ChatGPT أو DeepSeek
- 📱 **مراسلة WhatsApp**: إرسال رسائل واتساب بالجملة
- 📊 **إحصائيات شاملة**: متابعة الحملات والرسائل المرسلة
- 🎨 **واجهة احترافية**: تصميم عصري وسهل الاستخدام
- 💾 **قاعدة بيانات**: حفظ جميع البيانات والحملات

## 📋 المتطلبات

- Python 3.8 أو أحدث
- حساب Google Cloud مع Google Maps API
- مفتاح API من OpenAI أو DeepSeek

## 🔧 التثبيت

### 1. تثبيت Python Dependencies

```bash
pip install -r requirements.txt
```

### 2. إعداد ملف البيئة

انسخ ملف `.env.example` إلى `.env` وأضف مفاتيحك:

```bash
cp .env.example .env
```

أو على Windows:
```cmd
copy .env.example .env
```

ثم افتح ملف `.env` وأضف المفاتيح الخاصة بك.

### 3. تهيئة قاعدة البيانات

```bash
python database.py
```

### 4. تشغيل التطبيق

```bash
python app.py
```

أو استخدم ملف `run.bat` على Windows:
```cmd
run.bat
```

التطبيق سيعمل على: **http://localhost:5000**

## 🎯 كيفية الاستخدام

### 1. البحث عن الأعمال

1. افتح التطبيق في المتصفح
2. أدخل نوع العمل (مثال: مطاعم، صيدليات)
3. أدخل الموقع (مثال: الرياض، جدة)
4. اضغط "بدء البحث"

### 2. توليد رسائل بالذكاء الاصطناعي

1. حدد الأعمال المطلوبة من النتائج
2. اضغط "توليد رسائل بالذكاء الاصطناعي"
3. اختر محرك الذكاء الاصطناعي (ChatGPT أو DeepSeek)
4. أدخل قالب الرسالة (يمكنك استخدام متغيرات مثل `{name}`, `{category}`)
5. اضغط "توليد الرسائل"

### 3. إرسال رسائل WhatsApp

1. بعد توليد الرسائل، اضغط "إرسال عبر الواتساب"
2. سيتم إرسال الرسائل تلقائياً
3. يمكنك متابعة نتائج الإرسال

## 🔑 الحصول على API Keys

### Google Maps API

1. اذهب إلى [Google Cloud Console](https://console.cloud.google.com/)
2. أنشئ مشروع جديد أو اختر مشروع موجود
3. فعّل Google Maps Places API
4. أنشئ API Key من "Credentials"
5. انسخ المفتاح وضعه في ملف `.env`

### OpenAI API (ChatGPT)

1. اذهب إلى [OpenAI Platform](https://platform.openai.com/)
2. أنشئ حساب أو سجل دخول
3. اذهب إلى API Keys
4. أنشئ مفتاح جديد
5. انسخه وضعه في ملف `.env`

### DeepSeek API

1. اذهب إلى [DeepSeek Platform](https://platform.deepseek.com/)
2. أنشئ حساب
3. احصل على API Key
4. انسخه وضعه في ملف `.env`

## 📱 إعداد WhatsApp

النظام يدعم عدة طرق لإرسال رسائل WhatsApp:

### الخيار 1: Twilio (موصى به)

1. أنشئ حساب على [Twilio](https://www.twilio.com/)
2. فعّل WhatsApp API
3. أضف بيانات الاعتماد في ملف `.env`:
   ```
   TWILIO_ACCOUNT_SID=your_account_sid
   TWILIO_AUTH_TOKEN=your_auth_token
   TWILIO_WHATSAPP_NUMBER=whatsapp:+14155238886
   ```

### الخيار 2: WhatsApp Business API

يمكنك الربط مع WhatsApp Business API الرسمي

### الخيار 3: حلول مخصصة

يمكن استخدام مكتبات مثل:
- whatsapp-web.js
- Baileys
- WPPConnect

## 🗂️ هيكل المشروع

```
search/
├── app.py                      # التطبيق الرئيسي Flask
├── config.py                   # الإعدادات
├── database.py                 # قاعدة البيانات
├── google_maps_scraper.py      # استخراج بيانات Google Maps
├── ai_integration.py           # الذكاء الاصطناعي
├── whatsapp_integration.py     # إرسال WhatsApp
├── requirements.txt            # المكتبات المطلوبة
├── .env.example               # مثال ملف البيئة
├── templates/
│   └── index.html             # الواجهة الرئيسية
├── static/
│   ├── style.css              # التصميم
│   └── script.js              # JavaScript
└── marketing_system.db        # قاعدة البيانات (تُنشأ تلقائياً)
```

## 🔒 الأمان

- **لا تشارك** ملف `.env` أبداً
- احتفظ بمفاتيح API آمنة
- استخدم HTTPS في الإنتاج
- راجع حدود الاستخدام لكل API

## 📊 API Endpoints

### البحث
- `POST /api/search` - البحث عن أعمال
- `GET /api/businesses` - جلب الأعمال المحفوظة

### الذكاء الاصطناعي
- `POST /api/ai/generate-message` - توليد رسالة واحدة
- `POST /api/ai/customize-bulk` - تخصيص رسائل متعددة

### WhatsApp
- `POST /api/whatsapp/send` - إرسال رسالة واحدة
- `POST /api/whatsapp/send-bulk` - إرسال رسائل متعددة

### الحملات
- `GET /api/campaigns` - جلب الحملات
- `POST /api/campaigns` - إنشاء حملة جديدة

### الإحصائيات
- `GET /api/stats` - إحصائيات النظام

## 🐛 حل المشاكل

### خطأ في Google Maps API
- تأكد من تفعيل Places API في Google Cloud
- تحقق من صحة API Key
- تأكد من عدم تجاوز حد الاستخدام

### خطأ في الذكاء الاصطناعي
- تحقق من صحة OpenAI أو DeepSeek API Key
- تأكد من توفر رصيد في الحساب

### مشاكل في WhatsApp
- تحقق من إعدادات Twilio
- تأكد من صحة صيغة أرقام الهواتف

## 📝 ملاحظات

- النظام الحالي يحاكي إرسال WhatsApp للاختبار
- للإنتاج، يجب ربط خدمة WhatsApp فعلية
- يمكن تخصيص حد البحث في `config.py`
- يُنصح باستخدام قاعدة بيانات PostgreSQL في الإنتاج

## 🤝 المساهمة

نرحب بأي مساهمات لتحسين النظام!

## 📄 الترخيص

هذا المشروع مفتوح المصدر

## 📞 الدعم

للدعم والاستفسارات، يمكنك فتح Issue في GitHub

---

صُنع بـ ❤️ لأصحاب الأعمال والمسوقين



