# 🚀 دليل البدء السريع

## الخطوات البسيطة للبدء:

### 1️⃣ تثبيت Python
إذا لم يكن Python مثبتاً، حمّله من:
https://www.python.org/downloads/

**مهم**: تأكد من تحديد "Add Python to PATH" أثناء التثبيت

### 2️⃣ إعداد المفاتيح

قم بتشغيل هذا الأمر لإنشاء ملف .env تلقائياً:

```bash
python setup_env.py
```

أو قم بإنشاء ملف `.env` يدوياً وانسخ المحتوى التالي:

```env
# API Keys
DEEPSEEK_API_KEY=sk-8503c62d8ee5481aaf15e729674deb14
OPENAI_API_KEY=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
GOOGLE_MAPS_API_KEY=AIzaSyAYGuFwowyd5OZ-ZTkw1MQMqpHdKturxS8

DATABASE_URL=sqlite:///marketing_system.db
FLASK_ENV=development
SECRET_KEY=your-secret-key-change-this-in-production
```

### 3️⃣ تشغيل النظام

#### على Windows:

**الطريقة الأولى (موصى بها):**
اضغط دبل كليك على ملف `run.bat`

**الطريقة الثانية:**
```bash
python app.py
```

**الطريقة الثالثة (PowerShell):**
```powershell
.\start.ps1
```

#### على Mac/Linux:

```bash
python3 app.py
```

### 4️⃣ فتح التطبيق

افتح المتصفح واذهب إلى:
```
http://localhost:5000
```

---

## 🎯 استخدام النظام في 3 خطوات:

### الخطوة 1: البحث
- أدخل نوع العمل (مثال: مطاعم، صيدليات، محلات ملابس)
- أدخل المنطقة (مثال: الرياض، جدة، الدمام)
- اضغط "بدء البحث"

### الخطوة 2: التخصيص
- حدد الأعمال التي تريدها
- اضغط "توليد رسائل بالذكاء الاصطناعي"
- اختر النموذج (ChatGPT أو DeepSeek)
- خصص قالب الرسالة

### الخطوة 3: الإرسال
- راجع الرسائل المولدة
- اضغط "إرسال عبر الواتساب"
- تابع النتائج والإحصائيات

---

## ⚠️ ملاحظات مهمة:

1. **Google Maps API**: 
   - لديك 60 عملية بحث مجانية شهرياً
   - بعد ذلك، يبدأ الدفع حسب الاستخدام

2. **OpenAI API**:
   - تحتاج إلى رصيد في حساب OpenAI
   - يمكنك استخدام DeepSeek كبديل أرخص

3. **WhatsApp**:
   - النظام الحالي يحاكي الإرسال للاختبار
   - للاستخدام الفعلي، تحتاج Twilio أو WhatsApp Business API

4. **الأمان**:
   - لا تشارك ملف `.env` مع أحد
   - لا تنشر مفاتيح API على الإنترنت

---

## 🆘 حل المشاكل الشائعة:

### "Python not found"
- تأكد من تثبيت Python
- تأكد من إضافة Python إلى PATH

### "No module named ..."
```bash
pip install -r requirements.txt
```

### "API Key Error"
- تحقق من صحة المفاتيح في ملف `.env`
- تأكد من تفعيل APIs في لوحات التحكم

### المنافذ مشغولة
إذا كان المنفذ 5000 مشغولاً، غيّره في `app.py`:
```python
app.run(debug=True, host='0.0.0.0', port=8080)
```

---

## 📞 تحتاج مساعدة؟

راجع ملف `README.md` للتوثيق الكامل

---

**🎉 استمتع بالنظام!**



