# 📦 دليل التثبيت الكامل (عربي)

## المتطلبات الأساسية

قبل البدء، تأكد من توفر:
- جهاز كمبيوتر يعمل بنظام Windows, Mac, أو Linux
- اتصال بالإنترنت
- مفاتيح API (Google Maps, OpenAI أو DeepSeek)

---

## الخطوة 1: تثبيت Python

### على Windows:

1. اذهب إلى https://www.python.org/downloads/
2. حمّل Python 3.8 أو أحدث
3. شغّل الملف المحمّل
4. **مهم جداً**: ضع علامة ✓ على "Add Python to PATH"
5. اضغط "Install Now"
6. انتظر حتى انتهاء التثبيت

للتحقق من التثبيت:
```cmd
python --version
```

### على Mac:

```bash
# باستخدام Homebrew (موصى به)
brew install python3

# التحقق
python3 --version
```

### على Linux (Ubuntu/Debian):

```bash
sudo apt update
sudo apt install python3 python3-pip

# التحقق
python3 --version
```

---

## الخطوة 2: تحميل المشروع

إذا كان لديك Git:
```bash
git clone <repository-url>
cd search
```

أو حمّل المشروع كملف ZIP وفك الضغط

---

## الخطوة 3: تثبيت المكتبات المطلوبة

### على Windows:

افتح Command Prompt أو PowerShell في مجلد المشروع:

```cmd
cd "D:\RAIED AI\search"
pip install -r requirements.txt
```

### على Mac/Linux:

```bash
cd /path/to/search
pip3 install -r requirements.txt
```

**ملاحظة**: إذا واجهت مشاكل في الصلاحيات على Mac/Linux، استخدم:
```bash
pip3 install --user -r requirements.txt
```

---

## الخطوة 4: إعداد ملف البيئة (.env)

### الطريقة الأولى (تلقائي):

```bash
python setup_env.py
```

### الطريقة الثانية (يدوي):

1. انسخ ملف `.env.example`:
   ```bash
   # Windows
   copy .env.example .env
   
   # Mac/Linux
   cp .env.example .env
   ```

2. افتح ملف `.env` في أي محرر نصوص

3. أضف مفاتيحك:
   ```env
   DEEPSEEK_API_KEY=your-key-here
   OPENAI_API_KEY=your-key-here
   GOOGLE_MAPS_API_KEY=your-key-here
   ```

---

## الخطوة 5: تهيئة قاعدة البيانات

```bash
python database.py
```

يجب أن ترى رسالة: "✅ تم إنشاء قاعدة البيانات بنجاح"

---

## الخطوة 6: اختبار النظام (اختياري)

```bash
python test_system.py
```

هذا السكريبت سيتحقق من:
- تثبيت جميع المكتبات
- وجود ملف .env
- صحة المفاتيح
- عمل قاعدة البيانات

---

## الخطوة 7: تشغيل النظام

### الطريقة 1 (Windows - الأسهل):
اضغط دبل كليك على `run.bat`

### الطريقة 2 (جميع الأنظمة):
```bash
python app.py
```

### الطريقة 3 (PowerShell):
```powershell
.\start.ps1
```

---

## الخطوة 8: فتح التطبيق

افتح المتصفح واذهب إلى:
```
http://localhost:5000
```

يجب أن تظهر لك الواجهة الرئيسية للنظام 🎉

---

## 🔧 حل المشاكل

### "python: command not found"

**السبب**: Python غير مثبت أو غير مضاف إلى PATH

**الحل**:
- على Windows: أعد تثبيت Python وتأكد من تحديد "Add to PATH"
- على Mac/Linux: استخدم `python3` بدلاً من `python`

### "pip: command not found"

**الحل**:
```bash
# Windows
python -m pip install -r requirements.txt

# Mac/Linux
python3 -m pip install -r requirements.txt
```

### "No module named 'flask'"

**السبب**: المكتبات غير مثبتة

**الحل**:
```bash
pip install flask flask-cors requests googlemaps openai python-dotenv sqlalchemy
```

### "Config validation failed"

**السبب**: مفاتيح API غير صحيحة أو ناقصة

**الحل**:
1. افتح ملف `.env`
2. تأكد من وجود جميع المفاتيح
3. تحقق من صحة المفاتيح (لا مسافات زائدة)

### "Port 5000 is already in use"

**السبب**: برنامج آخر يستخدم المنفذ 5000

**الحل**:
غيّر المنفذ في `app.py`:
```python
app.run(debug=True, host='0.0.0.0', port=8080)
```

ثم اذهب إلى: `http://localhost:8080`

### مشاكل في Google Maps API

**الأسباب المحتملة**:
- API Key غير صحيح
- Places API غير مفعّل في Google Cloud
- تجاوز حد الاستخدام المجاني

**الحل**:
1. اذهب إلى [Google Cloud Console](https://console.cloud.google.com/)
2. تأكد من تفعيل "Places API"
3. تحقق من حدود الاستخدام
4. تأكد من ربط بطاقة ائتمان (مطلوب حتى للخطة المجانية)

---

## 🔐 نصائح الأمان

1. **لا تشارك ملف `.env`** مع أي شخص
2. **لا تنشر المفاتيح** على GitHub أو أي مكان عام
3. **استخدم .gitignore** لتجنب رفع ملفات حساسة
4. **راقب استخدام APIs** لتجنب رسوم غير متوقعة
5. **غيّر SECRET_KEY** في الإنتاج

---

## 📊 استخدام APIs

### حدود الاستخدام المجاني:

**Google Maps Places API**:
- 0$ للأول $200 شهرياً
- بعد ذلك: حسب الاستخدام

**OpenAI API**:
- تحتاج إلى رصيد مدفوع
- GPT-4 تكلفته أعلى من GPT-3.5

**DeepSeek API**:
- أرخص من OpenAI
- جودة جيدة
- بديل ممتاز

---

## 🚀 الخطوات التالية

بعد التثبيت الناجح:

1. اقرأ ملف `QUICK_START.md` لبدء الاستخدام
2. جرّب البحث عن أعمال في منطقتك
3. خصّص الرسائل التسويقية
4. راجع الإحصائيات

---

## 📞 تحتاج مساعدة إضافية?

- راجع `README.md` للتوثيق الكامل
- راجع `QUICK_START.md` للبدء السريع
- شغّل `python test_system.py` للتشخيص

---

**تم بنجاح؟ 🎉 الآن يمكنك البدء في استخدام النظام!**



